@echo off
SetLocal EnableExtensions
SetLocal EnableDelayedExpansion

REM ========================================================================
REM Archive EQ log files
REM Stores in folder using Host Name and Timestamp to separate archives
REM Updated: 2021-08-23
REM ========================================================================

title EverQuest Move Character Logs Archive Utility


REM ========================================================================
REM specify source of EQ installation
REM ========================================================================
set "source=D:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"
echo "Source: %source%"


REM ========================================================================
REM specify base storage location
REM ========================================================================
set "base=%OneDrive%\Vault\EQ"
echo "Base: %base%"

REM ========================================================================
REM specify minimum filesize
REM ========================================================================
set "minSize=20000"
echo "Minimum filesize: %minSize% Bytes"


REM ========================================================================
REM generate datetimestamp YYYY-MM-DD__HH-MM-SS
REM ========================================================================
FOR /f "tokens=2 delims==" %%a in ('wmic os get localdatetime /value') DO set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "hours=%dt:~8,2%" & set "mins=%dt:~10,2%" & set "secs=%dt:~12,2%"
set "datestamp=%YYYY%-%MM%-%DD%" & set "timestamp=%hours%-%mins%-%secs%"
set "datetimestamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


:archivelogs
REM ========================================================================
REM MOVES log files with timestamp and workstation appended to filename to
REM the archive
REM ========================================================================
set "sourceLogs=%source%\Logs"
set "baseLogs=%base%\Logs"

if exist "%baseLogs%\" (
    echo Archive log directory found: %baseLogs%
) else (
    echo Creating archive log directory: %baseLogs%
    mkdir "%baseLogs%"
)

echo Scanning "%sourceLogs%" for log files...
set "indent=       "
FOR %%i IN (^"%sourceLogs%\*log*.txt^") DO (
    set "fSize=%%~zi"
    if !fSize! GEQ %minSize% (
    	set "fName=%%~ni"
    	set "fExt=%%~xi"
    	set "newFile=!fName!_!datetimestamp!_!ComputerName!!fExt!"
    	echo.
    	echo Rename "!fName!" ^(!fSize! Bytes^) -^>
    	echo %indent%"!newFile!"
    	REM rename "%%i" "!newFile!"
    	echo %indent%Move to "%baseLogs%"
    	move "%%i" "%baseLogs%\!newFile!"
    )
)
echo.
echo "Scanning completed."

:final
REM ========================================================================
REM End of script
REM ========================================================================
echo.
set /p _anykey_= Press any key to close window 
exit