@echo off
SetLocal EnableExtensions
SetLocal EnableDelayedExpansion

REM ========================================================================
REM Archive various EQ character configuration and log files
REM Stores in folder using Host Name and Timestamp to separate archives
REM Updated: 2021-08-23
REM ========================================================================
title EverQuest Character Archive Utility
SETLOCAL EnableExtensions


REM ========================================================================
REM specify source of EQ installation
REM ========================================================================
set "source=D:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"


REM ========================================================================
REM specify base storage location
REM ========================================================================
set "base=%OneDrive%\Vault\EQ"


REM ========================================================================
REM generate datetimestamp YYYY-MM-DD__HH-MM-SS
REM ========================================================================
FOR /f "tokens=2 delims==" %%a in ('wmic os get localdatetime /value') DO set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "hours=%dt:~8,2%" & set "mins=%dt:~10,2%" & set "secs=%dt:~12,2%"
set "datestamp=%YYYY%-%MM%-%DD%" & set "timestamp=%hours%-%mins%-%secs%"
set "datetimestamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


REM ========================================================================
REM Archive character configuration files per computer (timestamp)
REM ========================================================================
set "chardest=%base%\%ComputerName%\CharConfigBackup__%datetimestamp%"
md "%chardest%"
copy "%source%\*.ini" "%chardest%\" /b /y 
robocopy "%source%\userdata" "%chardest%\userdata" /e


REM ========================================================================
REM Archive Mail (no longer exists)
REM ========================================================================
REM robocopy "%source%\Mail" "%chardest%\Mail" /e


REM ========================================================================
REM Log file archival option
REM ========================================================================
REM eqlog, bzrlog, btrlog

set /p _logarchive_= Archive Log files (Y/N): 
IF "%_logarchive_%"=="Y" GOTO :archivelogs
:resumelogs


:final
REM ========================================================================
REM End of script
REM ========================================================================
echo.
set /p _anykey_= Press any key to close window 
exit


:archivelogs
REM ========================================================================
REM MOVES and Archives log files with timestamp and workstation appended
REM ========================================================================
set "sourceLogs=%source%\Logs"
set "baseLogs=%base%\Logs"

REM ========================================================================
REM specify minimum filesize
REM ========================================================================
set "minSize=20000"
echo "Minimum filesize: %minSize% Bytes"

if exist "%baseLogs%\" (
    echo Archive log directory found: %baseLogs%
) else (
    echo Creating archive log directory: %baseLogs%
    mkdir "%baseLogs%"
)

echo Scanning "%sourceLogs%" for log files...
set "indent=       "
FOR %%i IN (^"%sourceLogs%\*log*.txt^") DO (
    set "fSize=%%~zi"
    if !fSize! GEQ %minSize% (
    	set "fName=%%~ni"
    	set "fExt=%%~xi"
    	set "newFile=!fName!_!datetimestamp!_!ComputerName!!fExt!"
    	echo.
    	echo Rename "!fName!" ^(!fSize! Bytes^) -^>
    	echo %indent%"!newFile!"
    	REM rename "%%i" "!newFile!"
    	echo %indent%Move to "%baseLogs%"
    	move "%%i" "%baseLogs%\!newFile!"
    )
)
echo.
echo "Scanning completed."
GOTO :resumelogs