@echo off
SETLOCAL EnableExtensions
REM ========================================================================
REM Synchronize EQ settings
REM Updated: 2021-06-09
REM ========================================================================

set "synclog=%~dp0SyncEQ_log.txt"
title Sync Everquest Settings
echo Sync Everquest Settings > "%synclog%"

:rundatetime
REM generate datetimestamp YYYY-MM-DD__HH-MM-SS
for /f "tokens=2 delims==" %%a in ('wmic os get localdatetime /value') do set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "hours=%dt:~8,2%" & set "mins=%dt:~10,2%" & set "secs=%dt:~12,2%"
set "datestamp=%YYYY%-%MM%-%DD%" & set "timestamp=%hours%-%mins%-%secs%"
set "datetimestamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"

REM current date and time
echo Date: %datestamp% Time: %timestamp% Computer: %ComputerName%


:storagelocation
REM ========================================================================
REM specify base storage location
REM resolution/mode
REM ========================================================================
set "centralrepo=%OneDrive%\Vault\EQ\_repo"
echo Central repository: %centralrepo% >> "%synclog%"
set "resolutionmode=NotSpecified"
echo Resolution/Mode: %resolutionmode% >> "%synclog%"


:eqinstall
REM ========================================================================
REM specify source of EQ installation
REM ========================================================================
set "eqinstall=D:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"
echo EQ Install: %eqinstall% >> "%synclog%"


:syncfrom
REM ========================================================================
REM Sync From central repository
REM ========================================================================
set "syncfromhead=Sync ^<FROM^> central respository" >> "%synclog%"

REM copy UI template files
echo %syncfromhead%: UI templates >> "%synclog%"
robocopy "%centralrepo%" "%eqinstall%" UI*windowed*.ini UI*fullscreen*.ini /min:1 /XO /LOG+:"%synclog%"

REM ========================================================================
REM Copy UI files
REM Exclude EQ maintained UI files
robocopy "%centralrepo%\uifiles" "%eqinstall%\uifiles" /min:1 /E /XO /LOG+:"%synclog%" /xd "%centralrepo%\uifiles\default" /xd "%centralrepo%\uifiles\classic_spell_icons"

REM Character UI resolution/mode ini files
echo %syncfromhead%: UI character files (Resolution/mode) >> "%synclog%"
robocopy "%centralrepo%\%resolutionmode%" "%eqinstall%" UI_*_*.ini /min:1 /XO /LOG+:"%synclog%"

REM Character ini files (not UI)
echo %syncfromhead%: Character configuration (not UI) files >> "%synclog%"
robocopy "%centralrepo%" "%eqinstall%" *.ini /min:1 /XO /XF *_characters* defaults* eqclient* eqls* LaunchPad* Uninstaller* VoiceChat* UI* /LOG+:"%synclog%"

REM Archive Audio Triggers
echo %syncfromhead%: Audio Triggers >> "%synclog%"
robocopy "%centralrepo%\AudioTriggers" "%eqinstall%\AudioTriggers" /min:1 /E /XO /LOG+:"%synclog%"

REM Copy custom map files
echo %syncfromhead%: Maps >> "%synclog%"
REM Exclude EQ maintained map files
for /D %%i in ("%centralrepo%\maps\*") DO (
    robocopy "%%i" "%eqinstall%\maps\%%~ni" /min:1 /E /XO /LOG+:"%synclog%"
)

REM Copy /userdata (not resolution/mode specific)
echo %syncfromhead%: \userdata >> "%synclog%"
robocopy "%centralrepo%\userdata" "%eqinstall%\userdata" /min:1 /E /XO /LOG+:"%synclog%"


:syncto
REM ========================================================================
REM Sync to central repository
REM ========================================================================
set "synctohead= Sync ^<TO^> central respository"

REM copy UI template files
echo %synctohead%: UI templates >> "%synclog%"
robocopy "%eqinstall%" "%centralrepo%" UI*windowed*.ini UI*fullscreen.ini /min:1 /XO /LOG+:"%synclog%"

REM ========================================================================
REM Copy UI files
REM Exclude EQ maintained UI files
robocopy "%eqinstall%\uifiles" "%centralrepo%\uifiles" /min:1 /E /XO /LOG+:"%synclog%" /xd "%eqinstall%\uifiles\default" /xd "%eqinstall%\uifiles\classic_spell_icons"

REM Character UI resolution/mode ini files
echo %synctohead%: UI character files (Resolution/mode) >> "%synclog%"
robocopy "%eqinstall%" "%centralrepo%\%resolutionmode%" UI_*_*.ini /min:1 /XO /LOG+:"%synclog%"

REM Character ini files (not UI)
echo %synctohead%: Character configuration (not UI) files >> "%synclog%"
robocopy "%eqinstall%" "%centralrepo%" *.ini /min:1 /XO /XF *_characters* defaults* eqclient* eqls* LaunchPad* Uninstaller* VoiceChat* UI* /LOG+:"%synclog%"

REM Archive Audio Triggers
echo %synctohead%: Audio Triggers >> "%synclog%"
robocopy "%eqinstall%\AudioTriggers" "%centralrepo%\AudioTriggers" /min:1 /E /XO /LOG+:"%synclog%"

REM Copy custom map files
REM Exclude EQ maintained map files
echo %synctohead%: Maps >> "%synclog%"
for /D %%i in ("%eqinstall%\maps\*") DO (
    robocopy "%%i" "%centralrepo%\maps\%%~ni" /min:1 /E /XO /LOG+:"%synclog%"
)

REM Copy /userdata (not resolution/mode specific)
echo %synctohead%: \userdata >> "%synclog%"
robocopy "%eqinstall%\userdata" "%centralrepo%\userdata" /min:1 /E /XO /LOG+:"%synclog%"


:final
REM ========================================================================
REM End of script
REM ========================================================================
echo.
set /p _anykey_= Press any key to close window 
exit

