@ECHO OFF
SETLOCAL EnableDelayedExpansion EnableExtensions
:: ========================================================================
:: Synchronize files to cloud/network storage for multiple PCs
::
:: Created: 2021-11-09
:: Updated: 2023-09-05
:: ========================================================================


:: name
:: ========================================================================
:: name, used for title and log file prefix
:: ========================================================================
SET "name=Sync_Multi_EQ"


:: constants
:: ========================================================================
:: Constants
:: AUTOCLOSETERM: 0-prompts you to close window, any other-auto closes
:: CHAROTHERINI: base subfolder for filing other character ini
:: CHARUI: base subfolder for filing Character UI configs
:: EQCLIENT: base subfolder for filing eqclient files
:: USEGRANDMASTER: 1-syncs to/from master, allowing the master to act as a
::   local vault
:: SP2: 2 spaces, for formatting
:: ========================================================================
SET /A AUTOCLOSETERM=0
SET "CHAROTHERINI=char-other-ini"
SET "CHARUI=char-ui"
SET "DIV================================================================================"
SET "EQCLIENT=eqclient"
SET /A USEGRANDMASTER=0
SET "SP2=  "
SET "UNDER=-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-"

:: rundatetime
:: ========================================================================
:: dateTimeStamp: YYYY-MM-DD__HH-MM-SS
:: ========================================================================
FOR /f "tokens=2 delims==" %%a IN ('wmic os get localdatetime /value') DO SET "dt=%%a"
SET "YY=%dt:~2,2%" & SET "YYYY=%dt:~0,4%" & SET "MM=%dt:~4,2%" & SET "DD=%dt:~6,2%"
SET "hours=%dt:~8,2%" & SET "mins=%dt:~10,2%" & SET "secs=%dt:~12,2%"
SET "dateStamp=%YYYY%-%MM%-%DD%" & SET "timeStamp=%hours%-%mins%-%secs%"
SET "dateTimeStamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


:: logfile
:: ========================================================================
:: Log file (shows current run only)
:: ========================================================================
SET "synclog=%~dp0%name%_log.txt"
TITLE %name%
ECHO %name%> "%synclog%"


:: master
:: ========================================================================
:: Specify master location. Syncs with install(s). Syncs with grandmaster
::   if USEGRANDMASTER is 1
:: ========================================================================
SET "master=%OneDrive%\Vault\EQ\_master-2023"


:: grandmaster
:: ========================================================================
:: Specify grandmaster (network, cloud, etc) to sync with master
:: ========================================================================
REM SET "grandmaster=%OneDrive%\Vault\EQ\_master"


:: install
:: ========================================================================
:: Specify parameters of EQ installations (arrays)
:: 
:: eqInstall[#] is the # of the install directory and has the full path to 
::   the EverQuest root (required)
:: eqCharOtherINI[#] is the #'s group name for syncing
:: eqCharUIReso[#] is the install #'s resolution and mode to run EverQuest  
::   (HHHHxVVVVWindowed or HHHHvYYYYFullscreen), to group for syncing
:: eqClient[#] tracks the install #'s eqclient.ini to group for syncing
:: ========================================================================
SET "eqCharOtherINIDefault=Noob"
SET "eqCharUIResoDefault=Noob"
SET "eqClientDefault=Noob"

:: Specify install locations (start at 1, I am looking at you), eqInstall required
::   Defaults for eqInstall and eqClient are list above
:: ========================================================================
:: Install 1
SET "eqInstall[1]=C:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"
SET "eqCharOtherINI[1]=Live"
SET "eqCharUIReso[1]=Live-1920x1080Windowed"
SET "eqClient[1]=Live"
:: Install 2
SET "eqInstall[2]=C:\Users\Public\Daybreak Game Company\Installed Games\EverQuest Fullscreen"
SET "eqCharOtherINI[2]=Live"
SET "eqCharUIReso[2]=Live-1920x1080Fullscreen"
SET "eqClient[2]=Live"
:: Install 3
:: SET "eqInstall[3]=D:\Users\Public\Daybreak Game Company\Installed Games\EverQuest Beta"
:: SET "eqCharOtherINI[3]=Beta-2023"
:: SET "eqCharUIReso[3]=Beta-3440x1440Windowed"
:: SET "eqClient[3]=Beta-2023"

:: count eqInstall[]
SET installCount=0
SET i=0
:countinstall
SET /a i+=1
IF DEFINED eqInstall[%i%] (
	SET /a installCount+=1
	IF NOT DEFINED eqCharOtherINI[%i%] SET "eqCharOtherINI[%i%]=%eqCharOtherINIDefault%"
	IF NOT DEFINED eqCharUIReso[%i%] SET "eqCharUIReso[%i%]=%eqCharUIResoDefault%"
	IF NOT DEFINED eqClient[%i%] SET "eqClient[%i%]=%eqClientDefault%"
	GOTO :countinstall
)


:: checkinstallcount
IF %installCount% EQU 0 (ECHO eqInstall is not properly defined. Script terminated. & Exit 1)


:: outputconfig
ECHO Date: %dateStamp% Time: %timeStamp% Computer: %ComputerName% >> "%synclog%"
IF USEGRANDMASTER EQU 1 ECHO Grandmaster: %grandmaster% >> "%synclog%"
ECHO Master: %master% >> "%synclog%"
ECHO. >> "%synclog%"
ECHO Install(s) and options >> "%synclog%"
ECHO. >> "%synclog%"

FOR /l %%i IN (1,1,%installCount%) DO (
	ECHO #%%i: !eqInstall[%%i]! >>"%synclog%"	
	ECHO %SP2%Resolution: !eqCharUIReso[%%i]! >> "%synclog%"	
	ECHO %SP2%eqclient.ini: !eqClient[%%i]! >> "%synclog%"
)


:: grandmastertomaster
IF %USEGRANDMASTER% EQU 1 (
	ECHO. >> "%synclog%"
	ECHO %DIV% >> "%synclog%"
	ECHO Sync: grandmaster to master >> "%synclog%"
	ECHO %DIV% >> "%synclog%"
	CALL :syncstuff "%synclog%" "grandmaster" "%grandmaster%" "%master%" 0
)


:: mastertoinstall
ECHO. >> "%synclog%"
ECHO %DIV% >> "%synclog%"
ECHO Sync: master to install(s) >> "%synclog%"
ECHO %DIV% >> "%synclog%"
FOR /l %%i IN (1,1,%installCount%) DO (
	CALL :syncstuff "%synclog%" %%i "%master%" "!eqInstall[%%i]!" 2
)


:: installtomaster
ECHO. >> "%synclog%"
ECHO %DIV% >> "%synclog%"
ECHO Sync: install(s) to master >> "%synclog%"
ECHO %DIV% >> "%synclog%"
FOR /l %%i IN (1,1,%installCount%) DO (
	CALL :syncstuff "%synclog%" %%i "!eqInstall[%%i]!" "%master%" 1
)	


:: mastertograndmaster
IF %USEGRANDMASTER% EQU 1 (
	ECHO. >> "%synclog%"
	ECHO %DIV% >> "%synclog%"
	ECHO Sync: master to grandmaster >> "%synclog%"
	ECHO %DIV% >> "%synclog%"
	CALL :syncstuff "%synclog%" "master" "%master%" "%grandmaster%" 0
)


:final
:: ========================================================================
:: End of script
:: ========================================================================
IF %AUTOCLOSETERM% NEQ 0 EXIT

ECHO.
SET /p _anykey_= Press any key to close window 
EXIT


:: SUBROUTINES


:: %1 Batch log
:: %2 Install # / master / grandmaster
:: %3 Source
:: %4 Destination
:: %5 Mode (0-neither is install, 1-Source is install, 2-Destination is install)
:syncstuff
ECHO. >> "%~1"
ECHO #%~2: %~3 >> "%~1"
ECHO %UNDER% >> "%~1"

:: UI templates
ECHO %SP2%UI Templates >> "%~1"
ROBOCOPY "%~3" "%~4" UI*windowed*.ini UI*fullscreen.ini /min:1 /XO /LOG+:"%~1"

:: uifiles
ECHO %SP2%UI Files ^(exclude EQ default^) >> "%~1"
ROBOCOPY "%~3\uifiles" "%~4\uifiles" /min:1 /E /XO /XD "%~3\uifiles\default" /XD "%~3\uifiles\classic_spell_icons" /LOG+:"%~1"

:: Character configurations
ECHO %SP2%Character configuration ^(not UI^) files >> "%~1"
IF %~5 EQU 1 (ROBOCOPY "%~3" "%~4\%CHAROTHERINI%\!eqCharOtherINI[%2]!" *.ini /min:1 /XO /XF *_characters* defaults* eqclient* eqls* LaunchPad* Uninstaller* VoiceChat* UI* /LOG+:"%~1"
	) ELSE IF %~5 EQU 2 (ROBOCOPY "%~3\%CHAROTHERINI%\!eqCharOtherINI[%2]!" "%~4" *.ini /min:1 /XO /XF *_characters* defaults* eqclient* eqls* LaunchPad* Uninstaller* VoiceChat* UI* /LOG+:"%~1"
	) ELSE (ROBOCOPY "%~3\%CHAROTHERINI%" "%~4\%CHAROTHERINI%" *.ini /min:1 /S /XO /XF *_characters* defaults* eqclient* eqls* LaunchPad* Uninstaller* VoiceChat* UI* /LOG+:"%~1"
)

:: AudioTriggers
ECHO %SP2%Audio Triggers >> "%~1"
ROBOCOPY "%~3\AudioTriggers" "%~4\AudioTriggers" /min:1 /E /XO /LOG+:"%~1"

:: Custom maps
ECHO %SP2%Custom Maps >> "%~1"
FOR /D %%m in ("%~3\maps\*") DO (
	ROBOCOPY "%%m" "%~4\maps\%%~nm" /min:1 /E /XO /LOG+:"%~1"
)

:: userdata
ECHO %SP2%Folder: \userdata >> "%~1"
ROBOCOPY "%~3\userdata" "%~4\userdata" /min:1 /E /XO /LOG+:"%~1"

:: Character UI Files (resolution mode)
ECHO %SP2%Character UI Files ^(Resolution/mode^) >> "%~1"
IF %~5 EQU 1 (ROBOCOPY "%~3" "%~4\%CHARUI%\!eqCharUIReso[%2]!" UI_*_*.ini /min:1 /XO /LOG+:"%~1"
	) ELSE IF %~5 EQU 2 (ROBOCOPY "%~3\%CHARUI%\!eqCharUIReso[%2]!" "%~4" UI_*_*.ini /min:1 /XO /LOG+:"%~1"
	) ELSE (ROBOCOPY "%~3\%CHARUI%" "%~4\%CHARUI%" UI_*_*.ini /min:1 /S /XO /LOG+:"%~1"
)

:: eqclient.ini 
ECHO %SP2%eqclient^.ini >> "%~1"
IF %~5 EQU 1 (ROBOCOPY "%~3" "%~4\%EQCLIENT%\!eqClient[%2]!" eqclient.ini /min:1 /XO /LOG+:"%~1"
	) ELSE IF %~5 EQU 2 (ROBOCOPY "%~3\%EQCLIENT%\!eqClient[%2]!" "%~4" eqclient.ini /min:1 /XO /LOG+:"%~1"
	) ELSE (ROBOCOPY "%~3\%EQCLIENT%" "%~4\%EQCLIENT%" eqclient.ini /min:1 /S /XO /LOG+:"%~1"
)

exit /b